/**
  *******************************************************************************
  * 
  * @file    hal_uart.c
  * @brief   uart module driver.
  *
  * @version v1.0
  * @date 22 Aug 2018
  * @author  AE Team
  * @note
  *
  * copyright (C) shanghai Eastsoft Mictroelectornics Co. Ltd. All rights reseverd.
  *
  @verbatim
  =================================================================================
  			##### How to use this driver #####
  =================================================================================
  [..]  The lvd driver can be used as follows:
    (+) Initialize the lvd module by using lvd_init().
    (+) Get lvd status by using lvd_get_flag().

  @endverbatim
  *********************************************************************************
  */

#include <hic.h>
#include "hal_lvd.h"

/**
  * @addtogroup ES7P203_HAL
  * @{
  */

/**
  * @defgroup LVD lvd
  * @brief lvd module driver
  * @{
  */

/**
  * @defgroup Lvd_Public_Functions lvd Public Functions
  * @brief    Initizlization and Get lvd Status Functions
@verbatim
=================================================================================
		##### Lvd Public Functions #####
=================================================================================
  [..]  The lvd driver can be used as follows:
    (+) Initialize the lvd module.
    (+) Get lvd flag status.

@endverbatim
  * @{
  */

/**
  * @brief  Initialze the lvd module using specific threshold voltage.
  * @param  vol: specified threshold voltage,see @ref lvd_voltage_sel_t.
  * @param  trig: specified voltage trigger mode,see @ref lvd_trigger_mode_t.
  * @retval None.
  */
void lvd_init(lvd_voltage_sel_t vol, lvd_trigger_mode_t trig)
{
	assert_param((vol >= LVD_VOL_SEL_2_7) && (vol <= LVD_VOL_SEL_4_7));

	LVDFLTEN = 1;
	LVDIFS0  = trig & 0x01;
	LVDIFS1  = (trig >> 1) & 0x01;
	LVDVS0   = vol & 0x01;
	LVDVS1   = (vol >> 1) & 0x01;
	LVDVS2   = (vol >> 2) & 0x01;
	LVDVS3   = (vol >> 3) & 0x01;

	LVDEN    = 1;

	return;
}

/**
  * @brief  get lvd flag status.
  * @retval lvd flag status, see @ref lvd_status_t.
  */
lvd_status_t get_lvd_status(void)
{
	return LVDO;
}

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */
